/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.plan;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import cz.insophy.inplan.plan.Activity;
import cz.insophy.inplan.plan.CumulativeWorkplaceSchedule;
import cz.insophy.inplan.plan.WorkplaceSchedule;
import cz.insophy.inplan.planning.ActivityChange;
import cz.insophy.inplan.planning.algorithms.ActivityChangeStack;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.store.StoreSchedule;
import cz.insophy.inplan.store.StoreScheduleGroup;
import cz.insophy.inplan.store.StoreType;
import cz.insophy.inplan.util.TimeSpan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class Plan {
    private final ShopConfiguration shopConf;
    private final StoreScheduleGroup store;
    private final Map<Workplace, WorkplaceSchedule> workplaceSchedules;
    private final ActivityChangeStack activityChangeStack;

    public Plan(ShopConfiguration configuration) {
        if (configuration == null) {
            throw new NullPointerException("Configuration for the plan cannot be null.");
        }
        this.shopConf = configuration;
        this.store = new StoreScheduleGroup(configuration.getMatprods());
        HashMap<Workplace, WorkplaceSchedule> wScheds = new HashMap<Workplace, WorkplaceSchedule>();
        for (Workplace wp : configuration.getWorkplaces()) {
            if (wp.isCumulative()) {
                wScheds.put(wp, new CumulativeWorkplaceSchedule(this, wp));
                continue;
            }
            wScheds.put(wp, new WorkplaceSchedule(wp));
        }
        this.workplaceSchedules = Collections.unmodifiableMap(wScheds);
        this.activityChangeStack = new ActivityChangeStack();
    }

    public ShopConfiguration getShopConf() {
        return this.shopConf;
    }

    public StoreSchedule getStoreSchedule(StoreType type) {
        return this.store.getSchedule(type);
    }

    public WorkplaceSchedule getWorkplaceSchedule(Workplace workplace) {
        WorkplaceSchedule ws = this.workplaceSchedules.get(workplace);
        if (ws == null) {
            throw new IllegalArgumentException(workplace + " not part of current shop configuration.");
        }
        return ws;
    }

    public double getMatprodQty(Material matprod, long time) {
        return this.getStoreSchedule(StoreType.ACTUAL_ESTIMATE_VIEW).getQ(matprod, time, true);
    }

    public double getMatprodQty(String matprod, long time) {
        return this.getMatprodQty(this.shopConf.getMatprod(matprod), time);
    }

    public int getTotalNumOfActivities() {
        int cnt = 0;
        for (WorkplaceSchedule ws : this.workplaceSchedules.values()) {
            cnt += ws.getActivityCount();
        }
        return cnt += this.store.getPrimitiveActivityCount();
    }

    public void addActivity(Activity activity) {
        if (activity.getPlan() != null) {
            throw new IllegalStateException(activity + " is already part of some plan.");
        }
        activity.setPlan(this);
    }

    public void removeActivity(Activity activity) {
        if (activity.getPlan() != this) {
            throw new IllegalStateException(activity + " cannot be removed from plan, because it is not there.");
        }
        activity.setPlan(null);
    }

    public void unregisterChanges(List<ActivityChange> actChanges) {
        ListIterator<ActivityChange> i = actChanges.listIterator(actChanges.size());
        while (i.hasPrevious()) {
            ActivityChange activityChange = i.previous();
            switch (activityChange.getChangeType()) {
                case ADDED: {
                    this.removeActivity(activityChange.getActivity());
                    break;
                }
                case REMOVED: {
                    this.addActivity(activityChange.getActivity());
                }
            }
        }
    }

    public void registerChanges(List<ActivityChange> actChanges) {
        for (ActivityChange activityChange : actChanges) {
            switch (activityChange.getChangeType()) {
                case ADDED: {
                    this.addActivity(activityChange.getActivity());
                    break;
                }
                case REMOVED: {
                    this.removeActivity(activityChange.getActivity());
                }
            }
        }
        if (this.activityChangeStack.isTransactionInProgress()) {
            this.activityChangeStack.append(actChanges);
        }
    }

    public boolean isTransactionInProgress() {
        return this.activityChangeStack.isTransactionInProgress();
    }

    public void beginTransaction() {
        this.activityChangeStack.beginTransaction();
    }

    public void commit() {
        this.activityChangeStack.commit();
        if (!this.activityChangeStack.isTransactionInProgress()) {
            this.activityChangeStack.clear();
        }
    }

    public List<ActivityChange> getActualActivityChangeStack() {
        return new ArrayList<ActivityChange>(this.activityChangeStack.getActivityChangeList());
    }

    public List<ActivityChange> rollback() {
        List<ActivityChange> rollbackList = this.activityChangeStack.rollback();
        this.unregisterChanges(rollbackList);
        if (!this.activityChangeStack.isTransactionInProgress()) {
            this.activityChangeStack.clear();
        }
        return rollbackList;
    }

    public Iterable<Activity> activities() {
        ArrayList<Iterable<Activity>> iters = Lists.newArrayList();
        iters.add(this.store.primitiveActivities());
        for (WorkplaceSchedule ws : this.getWorkplaceSchedules()) {
            iters.add(ws.activities());
        }
        return Iterables.concat(iters);
    }

    public Collection<WorkplaceSchedule> getWorkplaceSchedules() {
        return this.workplaceSchedules.values();
    }

    public TimeSpan getTimeBounds() {
        TimeSpan wpsBounds = this.getWorkplaceTimeBounds();
        TimeSpan ssgBounds = this.getStoreTimeBounds();
        return TimeSpan.union(wpsBounds, ssgBounds);
    }

    public TimeSpan getWorkplaceTimeBounds() {
        Iterable<TimeSpan> wpsBounds = Iterables.transform(this.workplaceSchedules.values(), new Function<WorkplaceSchedule, TimeSpan>(){

            @Override
            public TimeSpan apply(WorkplaceSchedule from) {
                return from.getTimeBounds();
            }
        });
        return TimeSpan.union(wpsBounds);
    }

    public TimeSpan getStoreTimeBounds() {
        return this.store.getTimeBounds();
    }
}

